﻿using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace P7_1
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;
        //Переменная для работы с аудиоустройством
        AudioEngine audioEngine;
        //Переменная для работы с Wave-банком
        WaveBank waveBank;
        //Переменная для работы с Sound-банком
        SoundBank soundBank;
        //Переменная для работы с фоновой музыкой игры
        Cue musicCue;
        Texture2D texture;
        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            //Загружаем аудиоресурсы для игры
            audioEngine = new AudioEngine("Content\\Audio\\xP7_1.xgs");
            waveBank = new WaveBank(audioEngine, "Content\\Audio\\Sounds.xwb");
            soundBank = new SoundBank(audioEngine, "Content\\Audio\\SoundBank.xsb");
            //Присваиваем переменной ссылку на закладку с именем Music
            musicCue = soundBank.GetCue("Music");
            //Включаем проигрывание фоновой музыки
            musicCue.Play();
            this.IsMouseVisible = true;
            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);
            Services.AddService(typeof(SpriteBatch), spriteBatch);
            texture = Content.Load<Texture2D>("BallandBats");
            // Создаем игровые объекты
            for (int i=1;i<5;i++)
            {
                Components.Add(new spriteComp(this, ref texture,
                    new Rectangle(16, 203, 17, 17), i, this, soundBank));
            }
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            //Блок управления проигрыванием по нажатию клавиш
            //При нажатии клавиши A приостанавливаем проигрывание
            KeyboardState kbState = Keyboard.GetState();
            if (kbState.IsKeyDown(Keys.A))
            {
              musicCue.Pause();
            }
            //При нажатии клавиши S продолжаем проигрывание музыки
            if (kbState.IsKeyDown(Keys.S))
            {
                musicCue.Resume();
            }

            audioEngine.Update();
            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            graphics.GraphicsDevice.Clear(Color.CornflowerBlue);

            // TODO: Add your drawing code here
            spriteBatch.Begin();
            base.Draw(gameTime);
            spriteBatch.End();
        }
    }
}
